/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRule;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRuleFluentImpl;
import io.fabric8.openshift.api.model.EgressNetworkPolicySpec;
import io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class EgressNetworkPolicySpecFluentImpl<A extends EgressNetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements EgressNetworkPolicySpecFluent<A> {
    private List<EgressNetworkPolicyRuleBuilder> egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();

    public EgressNetworkPolicySpecFluentImpl() {
    }

    public EgressNetworkPolicySpecFluentImpl(EgressNetworkPolicySpec instance) {
        this.withEgress(instance.getEgress());
    }

    @Override
    public A addToEgress(int index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        this._visitables.get("egress").add(index >= 0 ? index : this._visitables.get("egress").size(), builder);
        this.egress.add(index >= 0 ? index : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(int index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("egress").size()) {
            this._visitables.get("egress").add(builder);
        } else {
            this._visitables.get("egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(EgressNetworkPolicyRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<EgressNetworkPolicyRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(EgressNetworkPolicyRule ... items) {
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<EgressNetworkPolicyRule> items) {
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<EgressNetworkPolicyRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            EgressNetworkPolicyRuleBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EgressNetworkPolicyRule> getEgress() {
        return EgressNetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public List<EgressNetworkPolicyRule> buildEgress() {
        return EgressNetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public EgressNetworkPolicyRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    @Override
    public EgressNetworkPolicyRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public EgressNetworkPolicyRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public EgressNetworkPolicyRule buildMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<EgressNetworkPolicyRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(EgressNetworkPolicyRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(EgressNetworkPolicyRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index, EgressNetworkPolicyRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.apply(this.egress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressNetworkPolicySpecFluentImpl that = (EgressNetworkPolicySpecFluentImpl)o;
        return !(this.egress != null ? !this.egress.equals(that.egress) : that.egress != null);
    }

    public int hashCode() {
        return Objects.hash(this.egress, super.hashCode());
    }

    public class EgressNestedImpl<N>
    extends EgressNetworkPolicyRuleFluentImpl<EgressNetworkPolicySpecFluent.EgressNested<N>>
    implements EgressNetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        private final EgressNetworkPolicyRuleBuilder builder;
        private final int index;

        EgressNestedImpl(int index, EgressNetworkPolicyRule item) {
            this.index = index;
            this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new EgressNetworkPolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressNetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

