/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildConfigSpecFluentImpl<A extends BuildConfigSpecFluent<A>>
extends BaseFluent<A>
implements BuildConfigSpecFluent<A> {
    private Long completionDeadlineSeconds;
    private Integer failedBuildsHistoryLimit;
    private Map<String, String> nodeSelector;
    private BuildOutputBuilder output;
    private BuildPostCommitSpecBuilder postCommit;
    private ResourceRequirementsBuilder resources;
    private SourceRevisionBuilder revision;
    private String runPolicy;
    private String serviceAccount;
    private BuildSourceBuilder source;
    private BuildStrategyBuilder strategy;
    private Integer successfulBuildsHistoryLimit;
    private List<BuildTriggerPolicyBuilder> triggers = new ArrayList<BuildTriggerPolicyBuilder>();

    public BuildConfigSpecFluentImpl() {
    }

    public BuildConfigSpecFluentImpl(BuildConfigSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds != null;
    }

    @Override
    public Integer getFailedBuildsHistoryLimit() {
        return this.failedBuildsHistoryLimit;
    }

    @Override
    public A withFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit) {
        this.failedBuildsHistoryLimit = failedBuildsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasFailedBuildsHistoryLimit() {
        return this.failedBuildsHistoryLimit != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    @Deprecated
    public BuildOutput getOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public BuildOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public A withOutput(BuildOutput output) {
        this._visitables.get("output").remove(this.output);
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.get("output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildOutputBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    @Deprecated
    public BuildPostCommitSpec getPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    @Override
    public BuildPostCommitSpec buildPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    @Override
    public A withPostCommit(BuildPostCommitSpec postCommit) {
        this._visitables.get("postCommit").remove(this.postCommit);
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.get("postCommit").add(this.postCommit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPostCommit() {
        return this.postCommit != null;
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit());
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : new BuildPostCommitSpecBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public SourceRevision getRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        this._visitables.get("revision").remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.get("revision").add(this.revision);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : new SourceRevisionBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : item);
    }

    @Override
    public String getRunPolicy() {
        return this.runPolicy;
    }

    @Override
    public A withRunPolicy(String runPolicy) {
        this.runPolicy = runPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRunPolicy() {
        return this.runPolicy != null;
    }

    @Override
    public A withNewRunPolicy(String arg1) {
        return this.withRunPolicy(new String(arg1));
    }

    @Override
    public A withNewRunPolicy(StringBuilder arg1) {
        return this.withRunPolicy(new String(arg1));
    }

    @Override
    public A withNewRunPolicy(StringBuffer arg1) {
        return this.withRunPolicy(new String(arg1));
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public A withNewServiceAccount(String arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuilder arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuffer arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    @Deprecated
    public BuildSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public BuildSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(BuildSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new BuildSourceBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    @Deprecated
    public BuildStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public BuildStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(BuildStrategy strategy) {
        this._visitables.get("strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new BuildStrategyBuilder().build());
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    public Integer getSuccessfulBuildsHistoryLimit() {
        return this.successfulBuildsHistoryLimit;
    }

    @Override
    public A withSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit) {
        this.successfulBuildsHistoryLimit = successfulBuildsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSuccessfulBuildsHistoryLimit() {
        return this.successfulBuildsHistoryLimit != null;
    }

    @Override
    public A addToTriggers(int index, BuildTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();
        }
        BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
        this._visitables.get("triggers").add(index >= 0 ? index : this._visitables.get("triggers").size(), builder);
        this.triggers.add(index >= 0 ? index : this.triggers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggers(int index, BuildTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();
        }
        BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get("triggers").size()) {
            this._visitables.get("triggers").add(builder);
        } else {
            this._visitables.get("triggers").set(index, builder);
        }
        if (index < 0 || index >= this.triggers.size()) {
            this.triggers.add(builder);
        } else {
            this.triggers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggers(BuildTriggerPolicy ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggers(Collection<BuildTriggerPolicy> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggers(Collection<BuildTriggerPolicy> items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTriggers(Predicate<BuildTriggerPolicyBuilder> predicate) {
        if (this.triggers == null) {
            return (A)this;
        }
        Iterator<BuildTriggerPolicyBuilder> each = this.triggers.iterator();
        Object visitables = this._visitables.get("triggers");
        while (each.hasNext()) {
            BuildTriggerPolicyBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildTriggerPolicy> getTriggers() {
        return BuildConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public List<BuildTriggerPolicy> buildTriggers() {
        return BuildConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public BuildTriggerPolicy buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    @Override
    public BuildTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    @Override
    public BuildTriggerPolicy buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    @Override
    public BuildTriggerPolicy buildMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        for (BuildTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        for (BuildTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTriggers(List<BuildTriggerPolicy> triggers) {
        if (this.triggers != null) {
            this._visitables.get("triggers").removeAll(this.triggers);
        }
        if (triggers != null) {
            this.triggers = new ArrayList<BuildTriggerPolicyBuilder>();
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = null;
        }
        return (A)this;
    }

    @Override
    public A withTriggers(BuildTriggerPolicy ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
        }
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item) {
        return new TriggersNestedImpl(-1, item);
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index, BuildTriggerPolicy item) {
        return new TriggersNestedImpl(index, item);
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> editTrigger(int index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException("Can't edit first triggers. The list is empty.");
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggers. The list is empty.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.apply(this.triggers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggers. No match found.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.failedBuildsHistoryLimit != null ? !this.failedBuildsHistoryLimit.equals(that.failedBuildsHistoryLimit) : that.failedBuildsHistoryLimit != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.postCommit != null ? !this.postCommit.equals(that.postCommit) : that.postCommit != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.runPolicy != null ? !this.runPolicy.equals(that.runPolicy) : that.runPolicy != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.successfulBuildsHistoryLimit != null ? !this.successfulBuildsHistoryLimit.equals(that.successfulBuildsHistoryLimit) : that.successfulBuildsHistoryLimit != null) {
            return false;
        }
        return !(this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null);
    }

    public int hashCode() {
        return Objects.hash(this.completionDeadlineSeconds, this.failedBuildsHistoryLimit, this.nodeSelector, this.output, this.postCommit, this.resources, this.revision, this.runPolicy, this.serviceAccount, this.source, this.strategy, this.successfulBuildsHistoryLimit, this.triggers, super.hashCode());
    }

    public class TriggersNestedImpl<N>
    extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluent.TriggersNested<N>>
    implements BuildConfigSpecFluent.TriggersNested<N>,
    Nested<N> {
        private final BuildTriggerPolicyBuilder builder;
        private final int index;

        TriggersNestedImpl(int index, BuildTriggerPolicy item) {
            this.index = index;
            this.builder = new BuildTriggerPolicyBuilder(this, item);
        }

        TriggersNestedImpl() {
            this.index = -1;
            this.builder = new BuildTriggerPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.setToTriggers(this.index, this.builder.build());
        }

        @Override
        public N endTrigger() {
            return this.and();
        }
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildConfigSpecFluent.StrategyNested<N>>
    implements BuildConfigSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildConfigSpecFluent.SourceNested<N>>
    implements BuildConfigSpecFluent.SourceNested<N>,
    Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildConfigSpecFluent.RevisionNested<N>>
    implements BuildConfigSpecFluent.RevisionNested<N>,
    Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withRevision(this.builder.build());
        }

        @Override
        public N endRevision() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildConfigSpecFluent.ResourcesNested<N>>
    implements BuildConfigSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNestedImpl<N>
    extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluent.PostCommitNested<N>>
    implements BuildConfigSpecFluent.PostCommitNested<N>,
    Nested<N> {
        private final BuildPostCommitSpecBuilder builder;

        PostCommitNestedImpl(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        PostCommitNestedImpl() {
            this.builder = new BuildPostCommitSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withPostCommit(this.builder.build());
        }

        @Override
        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildConfigSpecFluent.OutputNested<N>>
    implements BuildConfigSpecFluent.OutputNested<N>,
    Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }
}

