/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.SubscriptionOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class SubscriptionHandler
implements ResourceHandler<Subscription, SubscriptionBuilder> {
    @Override
    public String getKind() {
        return Subscription.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "operators.coreos.com/v1alpha1";
    }

    @Override
    public Subscription create(OkHttpClient client, Config config, String namespace, Subscription item) {
        return (Subscription)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Subscription[0]);
    }

    @Override
    public Subscription replace(OkHttpClient client, Config config, String namespace, Subscription item) {
        return (Subscription)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Subscription reload(OkHttpClient client, Config config, String namespace, Subscription item) {
        return (Subscription)((Gettable)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public SubscriptionBuilder edit(Subscription item) {
        return new SubscriptionBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Subscription item) {
        return (Boolean)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, Watcher<Subscription> watcher) {
        return (Watch)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, String resourceVersion, Watcher<Subscription> watcher) {
        return (Watch)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, ListOptions options, Watcher<Subscription> watcher) {
        return (Watch)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Subscription waitUntilReady(OkHttpClient client, Config config, String namespace, Subscription item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Subscription)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Subscription waitUntilCondition(OkHttpClient client, Config config, String namespace, Subscription item, Predicate<Subscription> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Subscription)((Resource)new SubscriptionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

