/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OAuthOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthHandler
implements ResourceHandler<OAuth, OAuthBuilder> {
    @Override
    public String getKind() {
        return OAuth.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public OAuth create(OkHttpClient client, Config config, String namespace, OAuth item) {
        return (OAuth)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new OAuth[0]);
    }

    @Override
    public OAuth replace(OkHttpClient client, Config config, String namespace, OAuth item) {
        return (OAuth)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public OAuth reload(OkHttpClient client, Config config, String namespace, OAuth item) {
        return (OAuth)((Gettable)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public OAuthBuilder edit(OAuth item) {
        return new OAuthBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, OAuth item) {
        return (Boolean)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, Watcher<OAuth> watcher) {
        return (Watch)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, String resourceVersion, Watcher<OAuth> watcher) {
        return (Watch)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuth item, ListOptions options, Watcher<OAuth> watcher) {
        return (Watch)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public OAuth waitUntilReady(OkHttpClient client, Config config, String namespace, OAuth item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuth)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public OAuth waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuth item, Predicate<OAuth> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuth)((Resource)new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

