/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.Release;
import io.fabric8.openshift.api.model.ReleaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ReleaseFluentImpl<A extends ReleaseFluent<A>>
extends BaseFluent<A>
implements ReleaseFluent<A> {
    private List<String> channels = new ArrayList<String>();
    private String image;
    private String url;
    private String version;

    public ReleaseFluentImpl() {
    }

    public ReleaseFluentImpl(Release instance) {
        this.withChannels(instance.getChannels());
        this.withImage(instance.getImage());
        this.withUrl(instance.getUrl());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToChannels(int index, String item) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        this.channels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToChannels(int index, String item) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        this.channels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToChannels(String ... items) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        for (String item : items) {
            this.channels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToChannels(Collection<String> items) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        for (String item : items) {
            this.channels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromChannels(String ... items) {
        for (String item : items) {
            if (this.channels == null) continue;
            this.channels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromChannels(Collection<String> items) {
        for (String item : items) {
            if (this.channels == null) continue;
            this.channels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    public String getChannel(int index) {
        return this.channels.get(index);
    }

    @Override
    public String getFirstChannel() {
        return this.channels.get(0);
    }

    @Override
    public String getLastChannel() {
        return this.channels.get(this.channels.size() - 1);
    }

    @Override
    public String getMatchingChannel(Predicate<String> predicate) {
        for (String item : this.channels) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingChannel(Predicate<String> predicate) {
        for (String item : this.channels) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withChannels(List<String> channels) {
        if (this.channels != null) {
            this._visitables.get("channels").removeAll(this.channels);
        }
        if (channels != null) {
            this.channels = new ArrayList<String>();
            for (String item : channels) {
                this.addToChannels(item);
            }
        } else {
            this.channels = null;
        }
        return (A)this;
    }

    @Override
    public A withChannels(String ... channels) {
        if (this.channels != null) {
            this.channels.clear();
        }
        if (channels != null) {
            for (String item : channels) {
                this.addToChannels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    @Override
    public A addNewChannel(String arg1) {
        return this.addToChannels(new String(arg1));
    }

    @Override
    public A addNewChannel(StringBuilder arg1) {
        return this.addToChannels(new String(arg1));
    }

    @Override
    public A addNewChannel(StringBuffer arg1) {
        return this.addToChannels(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public A withNewUrl(String arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(StringBuilder arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(StringBuffer arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseFluentImpl that = (ReleaseFluentImpl)o;
        if (this.channels != null ? !this.channels.equals(that.channels) : that.channels != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.channels, this.image, this.url, this.version, super.hashCode());
    }
}

