/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhook;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookConfigurationFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class MutatingWebhookConfigurationFluentImpl<A extends MutatingWebhookConfigurationFluent<A>>
extends BaseFluent<A>
implements MutatingWebhookConfigurationFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<MutatingWebhookBuilder> webhooks = new ArrayList<MutatingWebhookBuilder>();

    public MutatingWebhookConfigurationFluentImpl() {
    }

    public MutatingWebhookConfigurationFluentImpl(MutatingWebhookConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public MutatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public MutatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public MutatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public MutatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public MutatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToWebhooks(int index, MutatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<MutatingWebhookBuilder>();
        }
        MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
        this._visitables.get("webhooks").add(index >= 0 ? index : this._visitables.get("webhooks").size(), builder);
        this.webhooks.add(index >= 0 ? index : this.webhooks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWebhooks(int index, MutatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<MutatingWebhookBuilder>();
        }
        MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
        if (index < 0 || index >= this._visitables.get("webhooks").size()) {
            this._visitables.get("webhooks").add(builder);
        } else {
            this._visitables.get("webhooks").set(index, builder);
        }
        if (index < 0 || index >= this.webhooks.size()) {
            this.webhooks.add(builder);
        } else {
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhooks(MutatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<MutatingWebhookBuilder>();
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhooks(Collection<MutatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<MutatingWebhookBuilder>();
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhooks(MutatingWebhook ... items) {
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhooks(Collection<MutatingWebhook> items) {
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWebhooks(Predicate<MutatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)this;
        }
        Iterator<MutatingWebhookBuilder> each = this.webhooks.iterator();
        Object visitables = this._visitables.get("webhooks");
        while (each.hasNext()) {
            MutatingWebhookBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MutatingWebhook> getWebhooks() {
        return MutatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public List<MutatingWebhook> buildWebhooks() {
        return MutatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public MutatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    @Override
    public MutatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    @Override
    public MutatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    @Override
    public MutatingWebhook buildMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        for (MutatingWebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        for (MutatingWebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhooks(List<MutatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").removeAll(this.webhooks);
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList<MutatingWebhookBuilder>();
            for (MutatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhooks(MutatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
        }
        if (webhooks != null) {
            for (MutatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(MutatingWebhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index, MutatingWebhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public MutatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.apply(this.webhooks.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutatingWebhookConfigurationFluentImpl that = (MutatingWebhookConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.webhooks != null ? !this.webhooks.equals(that.webhooks) : that.webhooks != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks, super.hashCode());
    }

    public class WebhooksNestedImpl<N>
    extends MutatingWebhookFluentImpl<MutatingWebhookConfigurationFluent.WebhooksNested<N>>
    implements MutatingWebhookConfigurationFluent.WebhooksNested<N>,
    Nested<N> {
        private final MutatingWebhookBuilder builder;
        private final int index;

        WebhooksNestedImpl(int index, MutatingWebhook item) {
            this.index = index;
            this.builder = new MutatingWebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new MutatingWebhookBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookConfigurationFluentImpl.this.setToWebhooks(this.index, this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<MutatingWebhookConfigurationFluent.MetadataNested<N>>
    implements MutatingWebhookConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

