/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpec;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl;
import java.util.Objects;

public class NetworkSpecBuilder
extends NetworkSpecFluentImpl<NetworkSpecBuilder>
implements VisitableBuilder<NetworkSpec, NetworkSpecBuilder> {
    NetworkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSpecBuilder() {
        this(true);
    }

    public NetworkSpecBuilder(Boolean validationEnabled) {
        this(new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance) {
        this(fluent, instance, true);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalNetworks(instance.getAdditionalNetworks());
        fluent.withClusterNetwork(instance.getClusterNetwork());
        fluent.withDefaultNetwork(instance.getDefaultNetwork());
        fluent.withDeployKubeProxy(instance.getDeployKubeProxy());
        fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork());
        fluent.withKubeProxyConfig(instance.getKubeProxyConfig());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withServiceNetwork(instance.getServiceNetwork());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSpecBuilder(NetworkSpec instance) {
        this(instance, (Boolean)true);
    }

    public NetworkSpecBuilder(NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalNetworks(instance.getAdditionalNetworks());
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withDefaultNetwork(instance.getDefaultNetwork());
        this.withDeployKubeProxy(instance.getDeployKubeProxy());
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
        this.withKubeProxyConfig(instance.getKubeProxyConfig());
        this.withLogLevel(instance.getLogLevel());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkSpec build() {
        NetworkSpec buildable = new NetworkSpec(this.fluent.getAdditionalNetworks(), this.fluent.getClusterNetwork(), this.fluent.getDefaultNetwork(), this.fluent.isDeployKubeProxy(), this.fluent.isDisableMultiNetwork(), this.fluent.getKubeProxyConfig(), this.fluent.getLogLevel(), this.fluent.getServiceNetwork());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSpecBuilder that = (NetworkSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

