/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ClusterOperationsImpl
extends OperationSupport {
    private String versionEndpoint;

    public ClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(client, config, null, null, null, null, null);
        this.versionEndpoint = item;
    }

    public VersionInfo fetchVersion() {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(this.config.getMasterUrl(), this.versionEndpoint));
            Response response = this.client.newCall(requestBuilder.build()).execute();
            ObjectMapper objectMapper = new ObjectMapper();
            Map myMap = (Map)objectMapper.readValue(response.body().string(), HashMap.class);
            return new VersionInfo(myMap);
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
            return null;
        }
    }
}

