/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeClaimStatusFluentImpl<A extends PersistentVolumeClaimStatusFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimStatusFluent<A> {
    private List<String> accessModes;
    private Map<String, Quantity> capacity;
    private List<PersistentVolumeClaimConditionBuilder> conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
    private String phase;

    public PersistentVolumeClaimStatusFluentImpl() {
    }

    public PersistentVolumeClaimStatusFluentImpl(PersistentVolumeClaimStatus instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withPhase(instance.getPhase());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.accessModes);
            this.accessModes.clear();
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        if (this.capacity == null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        } else {
            this.capacity.clear();
        }
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A addToConditions(int index, PersistentVolumeClaimCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
        }
        PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, PersistentVolumeClaimCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
        }
        PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(PersistentVolumeClaimCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
        }
        for (PersistentVolumeClaimCondition item : items) {
            PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<PersistentVolumeClaimCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
        }
        for (PersistentVolumeClaimCondition item : items) {
            PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(PersistentVolumeClaimCondition ... items) {
        for (PersistentVolumeClaimCondition item : items) {
            PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<PersistentVolumeClaimCondition> items) {
        for (PersistentVolumeClaimCondition item : items) {
            PersistentVolumeClaimConditionBuilder builder = new PersistentVolumeClaimConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PersistentVolumeClaimCondition> getConditions() {
        return PersistentVolumeClaimStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<PersistentVolumeClaimCondition> buildConditions() {
        return PersistentVolumeClaimStatusFluentImpl.build(this.conditions);
    }

    @Override
    public PersistentVolumeClaimCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public PersistentVolumeClaimCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public PersistentVolumeClaimCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public PersistentVolumeClaimCondition buildMatchingCondition(Predicate<PersistentVolumeClaimConditionBuilder> predicate) {
        for (PersistentVolumeClaimConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<PersistentVolumeClaimCondition> conditions) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PersistentVolumeClaimConditionBuilder>();
        } else {
            this._visitables.removeAll(this.conditions);
            this.conditions.clear();
        }
        if (conditions != null) {
            for (PersistentVolumeClaimCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(PersistentVolumeClaimCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PersistentVolumeClaimCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(PersistentVolumeClaimCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(int index, PersistentVolumeClaimCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PersistentVolumeClaimConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimStatusFluentImpl that = (PersistentVolumeClaimStatusFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.phase != null ? !this.phase.equals(that.phase) : that.phase != null);
    }

    public class ConditionsNestedImpl<N>
    extends PersistentVolumeClaimConditionFluentImpl<PersistentVolumeClaimStatusFluent.ConditionsNested<N>>
    implements PersistentVolumeClaimStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, PersistentVolumeClaimCondition item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

