/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_0.Doneable;
import io.fabric8.kubernetes.api.model.v4_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResource;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_0.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_0.Config;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Replaceable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_0.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_0.internal.KubernetesDeserializer;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>>
extends HasMetadataOperation<T, L, D, Resource<T, D>>
implements MixedOperation<T, L, D, Resource<T, D>> {
    public CustomResourceOperationsImpl(OkHttpClient httpClient, Config configuration, CustomResourceDefinition crd, Class<T> resourceType, Class<L> resourceListType, Class<D> doneType) {
        this(httpClient, configuration, CustomResourceOperationsImpl.apiGroup(crd), CustomResourceOperationsImpl.apiVersion(crd), CustomResourceOperationsImpl.resourceT(crd), null, null, false, null, null, false, resourceType, resourceListType, doneType);
    }

    public CustomResourceOperationsImpl(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, type, listType, doneableType);
        this.apiGroupVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        KubernetesDeserializer.registerCustomKind(type.getSimpleName(), type);
        if (KubernetesResource.class.isAssignableFrom(listType)) {
            KubernetesDeserializer.registerCustomKind(listType.getSimpleName(), listType);
        }
    }

    protected static String apiGroup(CustomResourceDefinition crd) {
        return crd.getSpec().getGroup();
    }

    protected static String apiVersion(CustomResourceDefinition crd) {
        return crd.getSpec().getVersion();
    }

    protected static String resourceT(CustomResourceDefinition crd) {
        return crd.getSpec().getNames().getPlural();
    }

    protected static String name(CustomResourceDefinition crd) {
        return crd.getMetadata().getName();
    }

    @Override
    public NonNamespaceOperation<T, L, D, Resource<T, D>> inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public NonNamespaceOperation<T, L, D, Resource<T, D>> inNamespace(String namespace) {
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), namespace, this.getName(), this.isCascading(), (HasMetadata)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getType(), this.getListType(), this.getDoneableType());
    }

    @Override
    public Resource<T, D> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), this.getNamespace(), name, this.isCascading(), (HasMetadata)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getType(), this.getListType(), this.getDoneableType());
    }

    @Override
    public Replaceable<T, T> lockResourceVersion(String resourceVersion) {
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), this.getNamespace(), this.getName(), this.isCascading(), (HasMetadata)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getType(), this.getListType(), this.getDoneableType());
    }

    @Override
    protected Resource<T, D> createItemOperation(T item) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), this.getNamespace(), this.getName(), this.isCascading(), item, this.getResourceVersion(), this.isReloadingFromServer(), this.getType(), this.getListType(), this.getDoneableType());
    }

    @Override
    public Resource<T, D> load(InputStream is) {
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), this.getNamespace(), this.getName(), this.isCascading(), (HasMetadata)CustomResourceOperationsImpl.unmarshal(is, this.getType()), this.getResourceVersion(), this.isReloadingFromServer(), this.getType(), this.getListType(), this.getDoneableType());
    }

    @Override
    public Gettable<T> fromServer() {
        return new CustomResourceOperationsImpl(this.client, this.getConfig(), this.getAPIGroup(), this.getAPIVersion(), this.getResourceT(), this.getNamespace(), this.getName(), this.isCascading(), (HasMetadata)this.getItem(), this.getResourceVersion(), true, this.getType(), this.getListType(), this.getDoneableType());
    }
}

