/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_0.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.v4_0.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.v4_0.HorizontalPodAutoscalerSpecFluentImpl;

public class HorizontalPodAutoscalerSpecBuilder
extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerSpec, HorizontalPodAutoscalerSpecBuilder> {
    HorizontalPodAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerSpecBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, HorizontalPodAutoscalerSpec instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, HorizontalPodAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMaxReplicas(instance.getMaxReplicas());
        fluent.withMinReplicas(instance.getMinReplicas());
        fluent.withScaleTargetRef(instance.getScaleTargetRef());
        fluent.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance) {
        this(instance, (Boolean)true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HorizontalPodAutoscalerSpec build() {
        HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(this.fluent.getMaxReplicas(), this.fluent.getMinReplicas(), this.fluent.getScaleTargetRef(), this.fluent.getTargetCPUUtilizationPercentage());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

