/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.utils;

import io.fabric8.kubernetes.clnt.v3_1.RequestConfig;
import io.fabric8.kubernetes.clnt.v3_1.utils.Utils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ImpersonatorInterceptor
implements Interceptor {
    private final RequestConfig requestConfig;

    public ImpersonatorInterceptor(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (Utils.isNotNullOrEmpty(this.requestConfig.getImpersonateUsername())) {
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Impersonate-User", this.requestConfig.getImpersonateUsername());
            if (Utils.isNotNullOrEmpty(this.requestConfig.getImpersonateGroup())) {
                requestBuilder.addHeader("Impersonate-Group", this.requestConfig.getImpersonateGroup());
            }
            if (Utils.isNotNullOrEmpty(this.requestConfig.getImpersonateExtras())) {
                for (Map.Entry<String, String> entry : this.requestConfig.getImpersonateExtras().entrySet()) {
                    requestBuilder.addHeader("Impersonate-Extra-" + entry.getKey(), entry.getValue());
                }
            }
            request = requestBuilder.build();
        }
        return chain.proceed(request);
    }
}

