/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Predicate;
import io.fabric8.kubernetes.api.model.v3_1.NamespaceSpec;
import io.fabric8.kubernetes.api.model.v3_1.NamespaceSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NamespaceSpecFluentImpl<A extends NamespaceSpecFluent<A>>
extends BaseFluent<A>
implements NamespaceSpecFluent<A> {
    private List<String> finalizers = new ArrayList<String>();

    public NamespaceSpecFluentImpl() {
    }

    public NamespaceSpecFluentImpl(NamespaceSpec instance) {
        this.withFinalizers(instance.getFinalizers());
    }

    @Override
    public A addToFinalizers(int index, String item) {
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(int index, String item) {
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        this.finalizers.clear();
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        this.finalizers.clear();
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSpecFluentImpl that = (NamespaceSpecFluentImpl)o;
        return !(this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null);
    }
}

