/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_1.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.v3_1.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.v3_1.HorizontalPodAutoscalerStatusFluentImpl;

public class HorizontalPodAutoscalerStatusBuilder
extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerStatus, HorizontalPodAutoscalerStatusBuilder> {
    HorizontalPodAutoscalerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerStatusBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withDesiredReplicas(instance.getDesiredReplicas());
        fluent.withLastScaleTime(instance.getLastScaleTime());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance) {
        this(instance, (Boolean)true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HorizontalPodAutoscalerStatus build() {
        HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(this.fluent.getCurrentCPUUtilizationPercentage(), this.fluent.getCurrentReplicas(), this.fluent.getDesiredReplicas(), this.fluent.getLastScaleTime(), this.fluent.getObservedGeneration());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

