/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.zjsonpatch.internal.guava.Strings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KubernetesAttributesExtractor
implements AttributeExtractor<HasMetadata> {
    public static final String KIND = "kind";
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    private static final String VERSION_GROUP = "(?<version>[^/]+)";
    private static final String KIND_GROUP = "(?<kind>[^/]+)";
    private static final String NAME_GROUP = "(?<name>[^/]+)";
    private static final String NAMESPACE_GROUP = "(?<namespace>[^/]+)";
    protected static final Pattern NAMESPACED_NAMED_PATH = Pattern.compile("/api/(?<version>[^/]+)/namespaces/(?<namespace>[^/]+)/(?<kind>[^/]+)/(?<name>[^/]+)[^ ]*");
    protected static final Pattern NON_NAMESPACED_NAMED_PATH = Pattern.compile("/api//(?<kind>[^/]+)/(?<name>[^/]+)[^ ]*");
    protected static final Pattern NAMESPACED_CREATE_PATH = Pattern.compile("/api/(?<version>[^/]+)/namespaces/(?<namespace>[^/]+)/(?<kind>[^/]+)[^ ]*");
    protected static final Pattern NON_NAMESPACED_CREATE_PATH = Pattern.compile("/api//(?<kind>[^/]+)[^ ]*");

    public AttributeSet fromPath(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        Matcher m = NAMESPACED_NAMED_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NON_NAMESPACED_NAMED_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NAMESPACED_CREATE_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NON_NAMESPACED_CREATE_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet fromResource(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        Matcher m = NAMESPACED_NAMED_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NON_NAMESPACED_NAMED_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NAMESPACED_CREATE_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        m = NON_NAMESPACED_CREATE_PATH.matcher(s);
        if (m.matches()) {
            return KubernetesAttributesExtractor.extract(m);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(HasMetadata o) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        if (!Strings.isNullOrEmpty((String)o.getKind())) {
            attributes = attributes.add(new Attribute[]{new Attribute(KIND, o.getKind().toLowerCase())});
        }
        if (!Strings.isNullOrEmpty((String)o.getMetadata().getName())) {
            attributes = attributes.add(new Attribute[]{new Attribute(NAME, o.getMetadata().getName())});
        }
        if (!Strings.isNullOrEmpty((String)o.getMetadata().getNamespace())) {
            attributes = attributes.add(new Attribute[]{new Attribute(NAMESPACE, o.getMetadata().getNamespace())});
        }
        return attributes;
    }

    private static AttributeSet extract(Matcher m) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        if (m.matches()) {
            String namespace;
            String kind = m.group(KIND);
            if (!Strings.isNullOrEmpty((String)kind)) {
                if (kind.endsWith("s")) {
                    kind = kind.substring(0, kind.length() - 1);
                }
                attributes = attributes.add(new Attribute[]{new Attribute(KIND, kind)});
            }
            if (!Strings.isNullOrEmpty((String)(namespace = m.group(NAMESPACE)))) {
                attributes = attributes.add(new Attribute[]{new Attribute(NAMESPACE, namespace)});
            }
            try {
                String name = m.group(NAME);
                if (!Strings.isNullOrEmpty((String)name)) {
                    attributes = attributes.add(new Attribute[]{new Attribute(NAME, name)});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return attributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HasMetadata toKubernetesResource(String s) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8.name()));){
            HasMetadata hasMetadata = (HasMetadata)Serialization.unmarshal(stream);
            return hasMetadata;
        }
        catch (Exception e) {
            return null;
        }
    }
}

