/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.TemplateOperation;
import io.fabric8.openshift.client.dsl.TemplateResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class TemplateOperationsImpl
extends OpenShiftOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>>
implements TemplateOperation {
    private static final String EXPRESSION = "expression";
    private static final TypeReference<HashMap<String, String>> MAPS_REFERENCE = new TypeReference<HashMap<String, String>>(){};

    public TemplateOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public TemplateOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, Template item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "templates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KubernetesList process(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.process(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public KubernetesList process(InputStream is) {
        return this.process(TemplateOperationsImpl.unmarshal(is, MAPS_REFERENCE));
    }

    @Override
    public KubernetesList process(Map<String, String> valuesMap) {
        Template t = (Template)this.get();
        try {
            for (Parameter p : t.getParameters()) {
                String v = valuesMap.get(p.getName());
                if (v == null) continue;
                p.setGenerate(null);
                p.setValue(v);
            }
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)t));
            Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getProcessUrl());
            t = (Template)this.handleResponse(requestBuilder);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public KubernetesList process(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.process(valuesMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KubernetesList processLocally(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.processLocally(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public KubernetesList processLocally(InputStream is) {
        return this.processLocally(TemplateOperationsImpl.unmarshal(is, MAPS_REFERENCE));
    }

    @Override
    public KubernetesList processLocally(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.processLocally(valuesMap);
    }

    @Override
    public KubernetesList processLocally(Map<String, String> valuesMap) {
        Template t = (Template)this.get();
        List<Parameter> parameters = t != null ? t.getParameters() : null;
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(t != null && t.getObjects() != null ? t.getObjects() : Collections.emptyList())).build();
        try {
            String json = JSON_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (valuesMap.containsKey(name)) {
                            value = valuesMap.get(name);
                        } else if (Utils.isNotNullOrEmpty(parameter.getValue())) {
                            value = parameter.getValue();
                        } else if (EXPRESSION.equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            throw new IllegalArgumentException("No value available for parameter name: " + name);
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)JSON_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return list;
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", this.getNamespace()));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), "processedtemplates"));
        return requestUrl;
    }

    @Override
    public TemplateResource<Template, KubernetesList, DoneableTemplate> load(InputStream is) {
        Template template = null;
        Object item = TemplateOperationsImpl.unmarshal(is);
        if (item instanceof Template) {
            template = (Template)item;
        } else if (item instanceof HasMetadata) {
            template = ((TemplateBuilder)new TemplateBuilder().withObjects((HasMetadata)item)).build();
        } else if (item instanceof KubernetesResourceList) {
            List list = ((KubernetesResourceList)item).getItems();
            template = ((TemplateBuilder)((TemplateBuilder)new TemplateBuilder().withNewMetadata().endMetadata()).withObjects(list.toArray(new HasMetadata[list.size()]))).build();
        } else if (item instanceof HasMetadata[]) {
            template = ((TemplateBuilder)((TemplateBuilder)new TemplateBuilder().withNewMetadata().endMetadata()).withObjects((HasMetadata[])item)).build();
        } else if (item instanceof Collection) {
            ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
            for (Object o : (Collection)item) {
                if (!(o instanceof HasMetadata)) continue;
                items.add((HasMetadata)o);
            }
            template = ((TemplateBuilder)((TemplateBuilder)new TemplateBuilder().withNewMetadata().endMetadata()).withObjects(items.toArray(new HasMetadata[items.size()]))).build();
        }
        return new TemplateOperationsImpl(this.client, OpenShiftConfig.wrap(this.config), null, this.namespace, null, false, template, null, false, 0L, null, null, null, null, null);
    }
}

