/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v2_2.dsl.internal;

import io.fabric8.kubernetes.api.builder.v2_2.Function;
import io.fabric8.kubernetes.api.model.v2_2.Status;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.dsl.base.OperationSupport;
import io.fabric8.openshift.api.model.v2_2.DoneableProjectRequest;
import io.fabric8.openshift.api.model.v2_2.ProjectRequest;
import io.fabric8.openshift.clnt.v2_2.OpenShiftConfig;
import io.fabric8.openshift.clnt.v2_2.dsl.ProjectRequestOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ProjectRequestsOperationImpl
extends OperationSupport
implements ProjectRequestOperation {
    private final ProjectRequest item;

    public ProjectRequestsOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(client, config, null, null);
    }

    public ProjectRequestsOperationImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, ProjectRequest item) {
        super(client, config, null, apiVersion, "projectrequests", null, null);
        this.item = item;
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0], ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem(), ProjectRequest.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public DoneableProjectRequest createNew() {
        return new DoneableProjectRequest(new Function<ProjectRequest, ProjectRequest>(){

            @Override
            public ProjectRequest apply(ProjectRequest item) {
                try {
                    return ProjectRequestsOperationImpl.this.create(item);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        });
    }

    @Override
    public Status list() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(requestBuilder, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public ProjectRequest getItem() {
        return this.item;
    }
}

