/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_2.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_2.RouteSpec;
import io.fabric8.openshift.api.model.v2_2.RouteSpecFluent;
import io.fabric8.openshift.api.model.v2_2.RouteSpecFluentImpl;

public class RouteSpecBuilder
extends RouteSpecFluentImpl<RouteSpecBuilder>
implements VisitableBuilder<RouteSpec, RouteSpecBuilder> {
    RouteSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RouteSpecBuilder() {
        this(true);
    }

    public RouteSpecBuilder(Boolean validationEnabled) {
        this(new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance) {
        this(fluent, instance, true);
    }

    public RouteSpecBuilder(RouteSpecFluent<?> fluent, RouteSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAlternateBackends(instance.getAlternateBackends());
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withTls(instance.getTls());
        fluent.withTo(instance.getTo());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteSpecBuilder(RouteSpec instance) {
        this(instance, (Boolean)true);
    }

    public RouteSpecBuilder(RouteSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RouteSpec build() {
        RouteSpec buildable = new RouteSpec(this.fluent.getAlternateBackends(), this.fluent.getHost(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getTls(), this.fluent.getTo(), this.fluent.getWildcardPolicy());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecBuilder that = (RouteSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

