/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_2.Nested;
import io.fabric8.kubernetes.api.builder.v2_2.Predicate;
import io.fabric8.kubernetes.api.model.v2_2.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_2.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_2.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v2_2.ObjectReference;
import io.fabric8.kubernetes.api.model.v2_2.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v2_2.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v2_2.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.v2_2.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.v2_2.NamedClusterRoleBinding;
import io.fabric8.openshift.api.model.v2_2.NamedClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.v2_2.NamedClusterRoleBindingFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterPolicyBindingFluentImpl<A extends ClusterPolicyBindingFluent<A>>
extends BaseFluent<A>
implements ClusterPolicyBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder policyRef;
    private List<NamedClusterRoleBindingBuilder> roleBindings = new ArrayList<NamedClusterRoleBindingBuilder>();

    public ClusterPolicyBindingFluentImpl() {
    }

    public ClusterPolicyBindingFluentImpl(ClusterPolicyBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withPolicyRef(instance.getPolicyRef());
        this.withRoleBindings(instance.getRoleBindings());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public Boolean hasLastModified() {
        return this.lastModified != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getPolicyRef() {
        return this.policyRef != null ? this.policyRef.build() : null;
    }

    @Override
    public ObjectReference buildPolicyRef() {
        return this.policyRef != null ? this.policyRef.build() : null;
    }

    @Override
    public A withPolicyRef(ObjectReference policyRef) {
        this._visitables.remove(this.policyRef);
        if (policyRef != null) {
            this.policyRef = new ObjectReferenceBuilder(policyRef);
            this._visitables.add(this.policyRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyRef() {
        return this.policyRef != null;
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef() {
        return new PolicyRefNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item) {
        return new PolicyRefNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef());
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef() != null ? this.getPolicyRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRefLike(ObjectReference item) {
        return this.withNewPolicyRefLike(this.getPolicyRef() != null ? this.getPolicyRef() : item);
    }

    @Override
    public A addToRoleBindings(int index, NamedClusterRoleBinding item) {
        NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.roleBindings.add(index >= 0 ? index : this.roleBindings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoleBindings(int index, NamedClusterRoleBinding item) {
        NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.roleBindings.size()) {
            this.roleBindings.add(builder);
        } else {
            this.roleBindings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoleBindings(Collection<NamedClusterRoleBinding> items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoleBindings(Collection<NamedClusterRoleBinding> items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedClusterRoleBinding> getRoleBindings() {
        return ClusterPolicyBindingFluentImpl.build(this.roleBindings);
    }

    @Override
    public List<NamedClusterRoleBinding> buildRoleBindings() {
        return ClusterPolicyBindingFluentImpl.build(this.roleBindings);
    }

    @Override
    public NamedClusterRoleBinding buildRoleBinding(int index) {
        return this.roleBindings.get(index).build();
    }

    @Override
    public NamedClusterRoleBinding buildFirstRoleBinding() {
        return this.roleBindings.get(0).build();
    }

    @Override
    public NamedClusterRoleBinding buildLastRoleBinding() {
        return this.roleBindings.get(this.roleBindings.size() - 1).build();
    }

    @Override
    public NamedClusterRoleBinding buildMatchingRoleBinding(Predicate<NamedClusterRoleBindingBuilder> predicate) {
        for (NamedClusterRoleBindingBuilder item : this.roleBindings) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRoleBindings(List<NamedClusterRoleBinding> roleBindings) {
        this._visitables.removeAll(this.roleBindings);
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoleBindings(NamedClusterRoleBinding ... roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleBindings() {
        return this.roleBindings != null && !this.roleBindings.isEmpty();
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding() {
        return new RoleBindingsNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedClusterRoleBinding item) {
        return new RoleBindingsNestedImpl(-1, item);
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> setNewRoleBindingLike(int index, NamedClusterRoleBinding item) {
        return new RoleBindingsNestedImpl(index, item);
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editRoleBinding(int index) {
        if (this.roleBindings.size() <= index) {
            throw new RuntimeException("Can't edit roleBindings. Index exceeds size.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editFirstRoleBinding() {
        if (this.roleBindings.size() == 0) {
            throw new RuntimeException("Can't edit first roleBindings. The list is empty.");
        }
        return this.setNewRoleBindingLike(0, this.buildRoleBinding(0));
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editLastRoleBinding() {
        int index = this.roleBindings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last roleBindings. The list is empty.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editMatchingRoleBinding(Predicate<NamedClusterRoleBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.roleBindings.size(); ++i) {
            if (!predicate.apply(this.roleBindings.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching roleBindings. No match found.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPolicyBindingFluentImpl that = (ClusterPolicyBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.policyRef != null ? !this.policyRef.equals(that.policyRef) : that.policyRef != null) {
            return false;
        }
        return !(this.roleBindings != null ? !this.roleBindings.equals(that.roleBindings) : that.roleBindings != null);
    }

    public class RoleBindingsNestedImpl<N>
    extends NamedClusterRoleBindingFluentImpl<ClusterPolicyBindingFluent.RoleBindingsNested<N>>
    implements ClusterPolicyBindingFluent.RoleBindingsNested<N>,
    Nested<N> {
        private final NamedClusterRoleBindingBuilder builder;
        private final int index;

        RoleBindingsNestedImpl(int index, NamedClusterRoleBinding item) {
            this.index = index;
            this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }

        RoleBindingsNestedImpl() {
            this.index = -1;
            this.builder = new NamedClusterRoleBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.setToRoleBindings(this.index, this.builder.build());
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }
    }

    public class PolicyRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterPolicyBindingFluent.PolicyRefNested<N>>
    implements ClusterPolicyBindingFluent.PolicyRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        PolicyRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        PolicyRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withPolicyRef(this.builder.build());
        }

        @Override
        public N endPolicyRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterPolicyBindingFluent.MetadataNested<N>>
    implements ClusterPolicyBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

