/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_2.internal;

import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import java.util.Comparator;

public class HasMetadataComparator
implements Comparator<HasMetadata> {
    private Integer getKindValue(String kind) {
        try {
            switch (kind) {
                case "SecurityContextConstraints": {
                    return 0;
                }
                case "Namespace": 
                case "Project": 
                case "ProjectRequest": {
                    return 1;
                }
                case "Secret": {
                    return 2;
                }
                case "ServiceAccount": {
                    return 3;
                }
                case "OAuthClient": {
                    return 4;
                }
                case "Service": {
                    return 5;
                }
                case "PolicyBinding": {
                    return 6;
                }
                case "ClusterPolicyBinding": {
                    return 7;
                }
                case "Role": {
                    return 8;
                }
                case "RoleBinding": {
                    return 9;
                }
                case "PersistentVolume": {
                    return 20;
                }
                case "PersistentVolumeClaim": {
                    return 21;
                }
                case "ImageStream": {
                    return 30;
                }
                case "ImageStreamTag": {
                    return 31;
                }
            }
            return 100;
        }
        catch (IllegalArgumentException e) {
            return 100;
        }
    }

    @Override
    public int compare(HasMetadata a, HasMetadata b) {
        String classNameB;
        if (a == null || b == null) {
            throw new NullPointerException("Cannot compare null HasMetadata objects");
        }
        if (a == b || a.equals(b)) {
            return 0;
        }
        int kindOrderCompare = this.getKindValue(a.getKind()).compareTo(this.getKindValue(b.getKind()));
        if (kindOrderCompare != 0) {
            return kindOrderCompare;
        }
        String classNameA = a.getClass().getSimpleName();
        int classCompare = classNameA.compareTo(classNameB = b.getClass().getSimpleName());
        if (classCompare != 0) {
            return classCompare;
        }
        return a.getMetadata().getName().compareTo(b.getMetadata().getName());
    }
}

