/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_2.dsl.base;

import io.fabric8.kubernetes.api.builder.v2_2.Function;
import io.fabric8.kubernetes.api.model.v2_2.Doneable;
import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_2.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v2_2.Config;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v2_2.Watch;
import io.fabric8.kubernetes.clnt.v2_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v2_2.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v2_2.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v2_2.internal.readiness.ReadinessWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends BaseOperation<T, L, D, R> {
    protected HasMetadataOperation(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public D edit() throws KubernetesClientException {
        Function visitor = new Function<T, T>(){

            @Override
            public T apply(T resource) {
                try {
                    if (HasMetadataOperation.this.isCascading().booleanValue() && !HasMetadataOperation.this.isReaping() && HasMetadataOperation.this.reaper != null) {
                        HasMetadataOperation.this.setReaping(true);
                        HasMetadataOperation.this.reaper.reap();
                    }
                    return HasMetadataOperation.this.patch(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            HasMetadata item = (HasMetadata)this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if ((got = (HasMetadata)this.get()) == null) {
                    return null;
                }
                Function visitor = new Function<T, T>(){

                    @Override
                    public T apply(T resource) {
                        try {
                            resource.getMetadata().setResourceVersion(got.getMetadata().getResourceVersion());
                            return (HasMetadata)HasMetadataOperation.this.handleReplace(resource);
                        }
                        catch (Exception e) {
                            throw KubernetesClientException.launderThrowable(e);
                        }
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(caught);
    }

    @Override
    public T patch(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if ((got = (HasMetadata)this.get()) == null) {
                    return null;
                }
                Function visitor = new Function<T, T>(){

                    @Override
                    public T apply(T resource) {
                        try {
                            return HasMetadataOperation.this.handlePatch(got, resource);
                        }
                        catch (Exception e) {
                            throw KubernetesClientException.launderThrowable(e);
                        }
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(caught);
    }

    protected T periodicWatchUntilReady(int i, long started, long interval, long amount) {
        HasMetadata item = (HasMetadata)this.fromServer().get();
        if (Readiness.isReady(item)) {
            return (T)item;
        }
        ReadinessWatcher<HasMetadata> watcher = new ReadinessWatcher<HasMetadata>(item);
        Throwable throwable = null;
        try (Watch watch = this.watch(watcher);){
            HasMetadata hasMetadata = watcher.await(interval, TimeUnit.MILLISECONDS);
            return (T)hasMetadata;
        }
        catch (KubernetesClientTimeoutException e) {
            if (i <= 0) {
                throw e;
            }
            long remaining = started + amount - System.currentTimeMillis();
            long next = Math.max(0L, Math.min(remaining, interval));
            T t = this.periodicWatchUntilReady(i - 1, started, next, amount);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

