/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_2;

import io.fabric8.kubernetes.api.model.v2_2.Status;

public class KubernetesClientException
extends RuntimeException {
    private int code;
    private Status status;

    public KubernetesClientException(String message) {
        super(message);
    }

    public KubernetesClientException(String message, Throwable t) {
        super(message, t);
    }

    public KubernetesClientException(Status status) {
        this(status.getMessage(), status.getCode(), status);
    }

    public KubernetesClientException(String message, int code, Status status) {
        super(message);
        this.code = code;
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public static RuntimeException launderThrowable(Throwable cause) {
        return KubernetesClientException.launderThrowable("An error has occurred.", cause);
    }

    public static RuntimeException launderThrowable(String message, Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new KubernetesClientException(message, cause);
    }
}

