/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_2;

import io.fabric8.kubernetes.api.model.v2_2.RootPaths;
import io.fabric8.kubernetes.clnt.v2_2.Adapters;
import io.fabric8.kubernetes.clnt.v2_2.Client;
import io.fabric8.kubernetes.clnt.v2_2.Config;
import io.fabric8.kubernetes.clnt.v2_2.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v2_2.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v2_2.HttpClientAware;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v2_2.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v2_2.utils.Utils;
import java.net.URL;
import okhttp3.OkHttpClient;

public abstract class BaseClient
implements Client,
HttpClientAware {
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) throws KubernetesClientException {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        if (this.httpClient.connectionPool() != null) {
            this.httpClient.connectionPool().evictAll();
        }
        if (this.httpClient.dispatcher() != null && this.httpClient.dispatcher().executorService() != null && !this.httpClient.dispatcher().executorService().isShutdown()) {
            this.httpClient.dispatcher().executorService().shutdown();
        }
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(this.httpClient, this.configuration, null, null, "", null, null, false, null, null, false, RootPaths.class, null, null){}.getRootPaths();
    }
}

