/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_2.extensions;

import io.fabric8.kubernetes.api.builder.v2_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_2.extensions.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v2_2.extensions.StatefulSetStatusFluent;
import io.fabric8.kubernetes.api.model.v2_2.extensions.StatefulSetStatusFluentImpl;

public class StatefulSetStatusBuilder
extends StatefulSetStatusFluentImpl<StatefulSetStatusBuilder>
implements VisitableBuilder<StatefulSetStatus, StatefulSetStatusBuilder> {
    StatefulSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetStatusBuilder() {
        this(true);
    }

    public StatefulSetStatusBuilder(Boolean validationEnabled) {
        this(new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance) {
        this(fluent, instance, true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSetStatus build() {
        StatefulSetStatus buildable = new StatefulSetStatus(this.fluent.getObservedGeneration(), this.fluent.getReplicas());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetStatusBuilder that = (StatefulSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

