/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_2;

import io.fabric8.kubernetes.api.builder.v2_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_2.ContainerStatus;
import io.fabric8.kubernetes.api.model.v2_2.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.v2_2.ContainerStatusFluentImpl;

public class ContainerStatusBuilder
extends ContainerStatusFluentImpl<ContainerStatusBuilder>
implements VisitableBuilder<ContainerStatus, ContainerStatusBuilder> {
    ContainerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStatusBuilder() {
        this(true);
    }

    public ContainerStatusBuilder(Boolean validationEnabled) {
        this(new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this(fluent, instance, true);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withImage(instance.getImage());
        fluent.withImageID(instance.getImageID());
        fluent.withLastState(instance.getLastState());
        fluent.withName(instance.getName());
        fluent.withReady(instance.getReady());
        fluent.withRestartCount(instance.getRestartCount());
        fluent.withState(instance.getState());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this(instance, (Boolean)true);
    }

    public ContainerStatusBuilder(ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withState(instance.getState());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerStatus build() {
        ContainerStatus buildable = new ContainerStatus(this.fluent.getContainerID(), this.fluent.getImage(), this.fluent.getImageID(), this.fluent.getLastState(), this.fluent.getName(), this.fluent.isReady(), this.fluent.getRestartCount(), this.fluent.getState());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusBuilder that = (ContainerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

