/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluentImpl;
import javax.validation.Validator;

public class ClusterRoleBindingBuilder
extends ClusterRoleBindingFluentImpl<ClusterRoleBindingBuilder>
implements VisitableBuilder<ClusterRoleBinding, ClusterRoleBindingBuilder> {
    ClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterRoleBindingBuilder() {
        this(true);
    }

    public ClusterRoleBindingBuilder(Boolean validationEnabled) {
        this(new ClusterRoleBinding(), validationEnabled);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterRoleBinding(), validationEnabled);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, ClusterRoleBinding instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, ClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingBuilder(ClusterRoleBinding instance) {
        this(instance, (Boolean)true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingBuilder(Validator validator) {
        this(new ClusterRoleBinding(), (Boolean)true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, ClusterRoleBinding instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ClusterRoleBindingBuilder(ClusterRoleBinding instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ClusterRoleBinding build() {
        ClusterRoleBinding buildable = new ClusterRoleBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingBuilder that = (ClusterRoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

