/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OpenshiftRole;
import io.fabric8.openshift.api.model.OpenshiftRoleFluent;
import io.fabric8.openshift.api.model.OpenshiftRoleFluentImpl;
import javax.validation.Validator;

public class OpenshiftRoleBuilder
extends OpenshiftRoleFluentImpl<OpenshiftRoleBuilder>
implements VisitableBuilder<OpenshiftRole, OpenshiftRoleBuilder> {
    OpenshiftRoleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OpenshiftRoleBuilder() {
        this(true);
    }

    public OpenshiftRoleBuilder(Boolean validationEnabled) {
        this(new OpenshiftRole(), validationEnabled);
    }

    public OpenshiftRoleBuilder(OpenshiftRoleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OpenshiftRoleBuilder(OpenshiftRoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OpenshiftRole(), validationEnabled);
    }

    public OpenshiftRoleBuilder(OpenshiftRoleFluent<?> fluent, OpenshiftRole instance) {
        this(fluent, instance, true);
    }

    public OpenshiftRoleBuilder(OpenshiftRoleFluent<?> fluent, OpenshiftRole instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public OpenshiftRoleBuilder(OpenshiftRole instance) {
        this(instance, (Boolean)true);
    }

    public OpenshiftRoleBuilder(OpenshiftRole instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public OpenshiftRoleBuilder(Validator validator) {
        this(new OpenshiftRole(), (Boolean)true);
    }

    public OpenshiftRoleBuilder(OpenshiftRoleFluent<?> fluent, OpenshiftRole instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public OpenshiftRoleBuilder(OpenshiftRole instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public OpenshiftRole build() {
        OpenshiftRole buildable = new OpenshiftRole(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftRoleBuilder that = (OpenshiftRoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

