/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.EventSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;

public class EventFluentImpl<A extends EventFluent<A>>
extends BaseFluent<A>
implements EventFluent<A> {
    private String apiVersion;
    private Integer count;
    private TimeBuilder firstTimestamp;
    private ObjectReferenceBuilder involvedObject;
    private String kind;
    private TimeBuilder lastTimestamp;
    private String message;
    private ObjectMetaBuilder metadata;
    private String reason;
    private EventSourceBuilder source;
    private String type;

    public EventFluentImpl() {
    }

    public EventFluentImpl(Event instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    @Deprecated
    public Time getFirstTimestamp() {
        return this.firstTimestamp != null ? this.firstTimestamp.build() : null;
    }

    @Override
    public Time buildFirstTimestamp() {
        return this.firstTimestamp != null ? this.firstTimestamp.build() : null;
    }

    @Override
    public A withFirstTimestamp(Time firstTimestamp) {
        this._visitables.remove(this.firstTimestamp);
        if (firstTimestamp != null) {
            this.firstTimestamp = new TimeBuilder(firstTimestamp);
            this._visitables.add(this.firstTimestamp);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    @Override
    public EventFluent.FirstTimestampNested<A> withNewFirstTimestamp() {
        return new FirstTimestampNestedImpl();
    }

    @Override
    public EventFluent.FirstTimestampNested<A> withNewFirstTimestampLike(Time item) {
        return new FirstTimestampNestedImpl(item);
    }

    @Override
    public EventFluent.FirstTimestampNested<A> editFirstTimestamp() {
        return this.withNewFirstTimestampLike(this.getFirstTimestamp());
    }

    @Override
    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestamp() {
        return this.withNewFirstTimestampLike(this.getFirstTimestamp() != null ? this.getFirstTimestamp() : new TimeBuilder().build());
    }

    @Override
    public EventFluent.FirstTimestampNested<A> editOrNewFirstTimestampLike(Time item) {
        return this.withNewFirstTimestampLike(this.getFirstTimestamp() != null ? this.getFirstTimestamp() : item);
    }

    @Override
    public A withNewFirstTimestamp(String time) {
        return this.withFirstTimestamp(new Time(time));
    }

    @Override
    @Deprecated
    public ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public ObjectReference buildInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public A withInvolvedObject(ObjectReference involvedObject) {
        this._visitables.remove(this.involvedObject);
        if (involvedObject != null) {
            this.involvedObject = new ObjectReferenceBuilder(involvedObject);
            this._visitables.add(this.involvedObject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject() {
        return new InvolvedObjectNestedImpl();
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item) {
        return new InvolvedObjectNestedImpl(item);
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item) {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public Time getLastTimestamp() {
        return this.lastTimestamp != null ? this.lastTimestamp.build() : null;
    }

    @Override
    public Time buildLastTimestamp() {
        return this.lastTimestamp != null ? this.lastTimestamp.build() : null;
    }

    @Override
    public A withLastTimestamp(Time lastTimestamp) {
        this._visitables.remove(this.lastTimestamp);
        if (lastTimestamp != null) {
            this.lastTimestamp = new TimeBuilder(lastTimestamp);
            this._visitables.add(this.lastTimestamp);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    @Override
    public EventFluent.LastTimestampNested<A> withNewLastTimestamp() {
        return new LastTimestampNestedImpl();
    }

    @Override
    public EventFluent.LastTimestampNested<A> withNewLastTimestampLike(Time item) {
        return new LastTimestampNestedImpl(item);
    }

    @Override
    public EventFluent.LastTimestampNested<A> editLastTimestamp() {
        return this.withNewLastTimestampLike(this.getLastTimestamp());
    }

    @Override
    public EventFluent.LastTimestampNested<A> editOrNewLastTimestamp() {
        return this.withNewLastTimestampLike(this.getLastTimestamp() != null ? this.getLastTimestamp() : new TimeBuilder().build());
    }

    @Override
    public EventFluent.LastTimestampNested<A> editOrNewLastTimestampLike(Time item) {
        return this.withNewLastTimestampLike(this.getLastTimestamp() != null ? this.getLastTimestamp() : item);
    }

    @Override
    public A withNewLastTimestamp(String time) {
        return this.withLastTimestamp(new Time(time));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    @Deprecated
    public EventSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public EventSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(EventSource source) {
        this._visitables.remove(this.source);
        if (source != null) {
            this.source = new EventSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public EventFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public EventFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public EventFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new EventSourceBuilder().build());
    }

    @Override
    public EventFluent.SourceNested<A> editOrNewSourceLike(EventSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public A withNewSource(String component, String host) {
        return this.withSource(new EventSource(component, host));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventFluentImpl that = (EventFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals(that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals(that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class SourceNestedImpl<N>
    extends EventSourceFluentImpl<EventFluent.SourceNested<N>>
    implements EventFluent.SourceNested<N>,
    Nested<N> {
        private final EventSourceBuilder builder;

        SourceNestedImpl(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>>
    implements EventFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class LastTimestampNestedImpl<N>
    extends TimeFluentImpl<EventFluent.LastTimestampNested<N>>
    implements EventFluent.LastTimestampNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        LastTimestampNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        LastTimestampNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withLastTimestamp(this.builder.build());
        }

        @Override
        public N endLastTimestamp() {
            return this.and();
        }
    }

    public class InvolvedObjectNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.InvolvedObjectNested<N>>
    implements EventFluent.InvolvedObjectNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        InvolvedObjectNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        InvolvedObjectNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withInvolvedObject(this.builder.build());
        }

        @Override
        public N endInvolvedObject() {
            return this.and();
        }
    }

    public class FirstTimestampNestedImpl<N>
    extends TimeFluentImpl<EventFluent.FirstTimestampNested<N>>
    implements EventFluent.FirstTimestampNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        FirstTimestampNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        FirstTimestampNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withFirstTimestamp(this.builder.build());
        }

        @Override
        public N endFirstTimestamp() {
            return this.and();
        }
    }
}

