/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSet;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluent;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpec;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatus;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatusFluentImpl;

public class PetSetFluentImpl<A extends PetSetFluent<A>>
extends BaseFluent<A>
implements PetSetFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PetSetSpecBuilder spec;
    private PetSetStatusBuilder status;

    public PetSetFluentImpl() {
    }

    public PetSetFluentImpl(PetSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PetSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PetSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PetSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PetSetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PetSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public PetSetSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public PetSetSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(PetSetSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new PetSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public PetSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PetSetFluent.SpecNested<A> withNewSpecLike(PetSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PetSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PetSetFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new PetSetSpecBuilder().build());
    }

    @Override
    public PetSetFluent.SpecNested<A> editOrNewSpecLike(PetSetSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public PetSetStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public PetSetStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(PetSetStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new PetSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public PetSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PetSetFluent.StatusNested<A> withNewStatusLike(PetSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PetSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public PetSetFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new PetSetStatusBuilder().build());
    }

    @Override
    public PetSetFluent.StatusNested<A> editOrNewStatusLike(PetSetStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A withNewStatus(Long observedGeneration, Integer replicas) {
        return this.withStatus(new PetSetStatus(observedGeneration, replicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetFluentImpl that = (PetSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends PetSetStatusFluentImpl<PetSetFluent.StatusNested<N>>
    implements PetSetFluent.StatusNested<N>,
    Nested<N> {
        private final PetSetStatusBuilder builder;

        StatusNestedImpl(PetSetStatus item) {
            this.builder = new PetSetStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PetSetStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PetSetSpecFluentImpl<PetSetFluent.SpecNested<N>>
    implements PetSetFluent.SpecNested<N>,
    Nested<N> {
        private final PetSetSpecBuilder builder;

        SpecNestedImpl(PetSetSpec item) {
            this.builder = new PetSetSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PetSetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PetSetFluent.MetadataNested<N>>
    implements PetSetFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

