/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import io.fabric8.openshift.api.model.SourceBuildStrategy;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import java.util.ArrayList;
import java.util.List;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>>
extends BaseFluent<A>
implements SourceBuildStrategyFluent<A> {
    private List<VisitableBuilder<? extends EnvVar, ?>> env = new ArrayList();
    private Boolean forcePull;
    private VisitableBuilder<? extends ObjectReference, ?> from;
    private Boolean incremental;
    private VisitableBuilder<? extends LocalObjectReference, ?> pullSecret;
    private List<VisitableBuilder<? extends ImageSourcePath, ?>> runtimeArtifacts = new ArrayList();
    private VisitableBuilder<? extends ObjectReference, ?> runtimeImage;
    private String scripts;

    public SourceBuildStrategyFluentImpl() {
    }

    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withIncremental(instance.getIncremental());
        this.withPullSecret(instance.getPullSecret());
        this.withRuntimeArtifacts(instance.getRuntimeArtifacts());
        this.withRuntimeImage(instance.getRuntimeImage());
        this.withScripts(instance.getScripts());
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return SourceBuildStrategyFluentImpl.build(this.env);
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this._visitables.removeAll(this.env);
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(item);
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public Boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public A withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return (A)this;
    }

    @Override
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? (LocalObjectReference)this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public A addToRuntimeArtifacts(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.add(builder);
            this.runtimeArtifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRuntimeArtifacts(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.remove(builder);
            this.runtimeArtifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageSourcePath> getRuntimeArtifacts() {
        return SourceBuildStrategyFluentImpl.build(this.runtimeArtifacts);
    }

    @Override
    public A withRuntimeArtifacts(List<ImageSourcePath> runtimeArtifacts) {
        this._visitables.removeAll(this.runtimeArtifacts);
        this.runtimeArtifacts.clear();
        if (runtimeArtifacts != null) {
            for (ImageSourcePath item : runtimeArtifacts) {
                this.addToRuntimeArtifacts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRuntimeArtifacts(ImageSourcePath ... runtimeArtifacts) {
        this.runtimeArtifacts.clear();
        if (runtimeArtifacts != null) {
            for (ImageSourcePath item : runtimeArtifacts) {
                this.addToRuntimeArtifacts(item);
            }
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifact() {
        return new RuntimeArtifactsNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeArtifactsNested<A> addNewRuntimeArtifactLike(ImageSourcePath item) {
        return new RuntimeArtifactsNestedImpl(item);
    }

    @Override
    public A addNewRuntimeArtifact(String destinationDir, String sourcePath) {
        return this.addToRuntimeArtifacts(new ImageSourcePath(destinationDir, sourcePath));
    }

    @Override
    public ObjectReference getRuntimeImage() {
        return this.runtimeImage != null ? (ObjectReference)this.runtimeImage.build() : null;
    }

    @Override
    public A withRuntimeImage(ObjectReference runtimeImage) {
        this._visitables.remove(this.runtimeImage);
        if (runtimeImage != null) {
            this.runtimeImage = new ObjectReferenceBuilder(runtimeImage);
            this._visitables.add(this.runtimeImage);
        }
        return (A)this;
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImage() {
        return new RuntimeImageNestedImpl();
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeImageNested<A> withNewRuntimeImageLike(ObjectReference item) {
        return new RuntimeImageNestedImpl(item);
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editRuntimeImage() {
        return this.withNewRuntimeImageLike(this.getRuntimeImage());
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImage() {
        return this.withNewRuntimeImageLike(this.getRuntimeImage() != null ? this.getRuntimeImage() : new ObjectReferenceBuilder().build());
    }

    @Override
    public SourceBuildStrategyFluent.RuntimeImageNested<A> editOrNewRuntimeImageLike(ObjectReference item) {
        return this.withNewRuntimeImageLike(this.getRuntimeImage() != null ? this.getRuntimeImage() : item);
    }

    @Override
    public String getScripts() {
        return this.scripts;
    }

    @Override
    public A withScripts(String scripts) {
        this.scripts = scripts;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.incremental != null ? !this.incremental.equals(that.incremental) : that.incremental != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        if (this.runtimeArtifacts != null ? !this.runtimeArtifacts.equals(that.runtimeArtifacts) : that.runtimeArtifacts != null) {
            return false;
        }
        if (this.runtimeImage != null ? !this.runtimeImage.equals(that.runtimeImage) : that.runtimeImage != null) {
            return false;
        }
        return !(this.scripts != null ? !this.scripts.equals(that.scripts) : that.scripts != null);
    }

    public class RuntimeImageNestedImpl<N>
    extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.RuntimeImageNested<N>>
    implements SourceBuildStrategyFluent.RuntimeImageNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        RuntimeImageNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RuntimeImageNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withRuntimeImage(this.builder.build());
        }

        @Override
        public N endRuntimeImage() {
            return this.and();
        }
    }

    public class RuntimeArtifactsNestedImpl<N>
    extends ImageSourcePathFluentImpl<SourceBuildStrategyFluent.RuntimeArtifactsNested<N>>
    implements SourceBuildStrategyFluent.RuntimeArtifactsNested<N>,
    Nested<N> {
        private final ImageSourcePathBuilder builder;

        RuntimeArtifactsNestedImpl(ImageSourcePath item) {
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        RuntimeArtifactsNestedImpl() {
            this.builder = new ImageSourcePathBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.addToRuntimeArtifacts(this.builder.build());
        }

        @Override
        public N endRuntimeArtifact() {
            return this.and();
        }
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SourceBuildStrategyFluent.PullSecretNested<N>>
    implements SourceBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<SourceBuildStrategyFluent.FromNested<N>>
    implements SourceBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<SourceBuildStrategyFluent.EnvNested<N>>
    implements SourceBuildStrategyFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;

        EnvNestedImpl(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)SourceBuildStrategyFluentImpl.this.addToEnv(this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

