/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusFluentImpl;

public class HorizontalPodAutoscalerFluentImpl<A extends HorizontalPodAutoscalerFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends HorizontalPodAutoscalerSpec, ?> spec;
    private VisitableBuilder<? extends HorizontalPodAutoscalerStatus, ?> status;

    public HorizontalPodAutoscalerFluentImpl() {
    }

    public HorizontalPodAutoscalerFluentImpl(HorizontalPodAutoscaler instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public HorizontalPodAutoscalerSpec getSpec() {
        return this.spec != null ? (HorizontalPodAutoscalerSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(HorizontalPodAutoscalerSpec spec) {
        if (spec != null) {
            this.spec = new HorizontalPodAutoscalerSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpecLike(HorizontalPodAutoscalerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public HorizontalPodAutoscalerStatus getStatus() {
        return this.status != null ? (HorizontalPodAutoscalerStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(HorizontalPodAutoscalerStatus status) {
        if (status != null) {
            this.status = new HorizontalPodAutoscalerStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatusLike(HorizontalPodAutoscalerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer currentCPUUtilizationPercentage, Integer currentReplicas, Integer desiredReplicas, String lastScaleTime, Long observedGeneration) {
        return this.withStatus(new HorizontalPodAutoscalerStatus(currentCPUUtilizationPercentage, currentReplicas, desiredReplicas, lastScaleTime, observedGeneration));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerFluentImpl that = (HorizontalPodAutoscalerFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerFluent.StatusNested<N>>
    implements HorizontalPodAutoscalerFluent.StatusNested<N>,
    Nested<N> {
        private final HorizontalPodAutoscalerStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new HorizontalPodAutoscalerStatusBuilder(this);
        }

        StatusNestedImpl(HorizontalPodAutoscalerStatus item) {
            this.builder = new HorizontalPodAutoscalerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerFluent.SpecNested<N>>
    implements HorizontalPodAutoscalerFluent.SpecNested<N>,
    Nested<N> {
        private final HorizontalPodAutoscalerSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new HorizontalPodAutoscalerSpecBuilder(this);
        }

        SpecNestedImpl(HorizontalPodAutoscalerSpec item) {
            this.builder = new HorizontalPodAutoscalerSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<HorizontalPodAutoscalerFluent.MetadataNested<N>>
    implements HorizontalPodAutoscalerFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

