/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;

public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>>
extends BaseFluent<A>
implements ResourceFieldSelectorFluent<A> {
    private String containerName;
    private VisitableBuilder<? extends Quantity, ?> divisor;
    private String resource;

    public ResourceFieldSelectorFluentImpl() {
    }

    public ResourceFieldSelectorFluentImpl(ResourceFieldSelector instance) {
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Quantity getDivisor() {
        return this.divisor != null ? (Quantity)this.divisor.build() : null;
    }

    @Override
    public A withDivisor(Quantity divisor) {
        if (divisor != null) {
            this.divisor = new QuantityBuilder(divisor);
            this._visitables.add(this.divisor);
        }
        return (A)this;
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor() {
        return new DivisorNestedImpl();
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item) {
        return new DivisorNestedImpl(item);
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor() {
        return this.withNewDivisorLike(this.getDivisor());
    }

    @Override
    public A withNewDivisor(String amount) {
        return this.withDivisor(new Quantity(amount));
    }

    @Override
    public A withNewDivisor(String amount, String format) {
        return this.withDivisor(new Quantity(amount, format));
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl)o;
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.divisor != null ? !this.divisor.equals(that.divisor) : that.divisor != null) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
    }

    public class DivisorNestedImpl<N>
    extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>>
    implements ResourceFieldSelectorFluent.DivisorNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        DivisorNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        DivisorNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        @Override
        public N endDivisor() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ResourceFieldSelectorFluentImpl.this.withDivisor(this.builder.build());
        }
    }
}

