/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.GitSourceRevision;
import io.fabric8.openshift.api.model.GitSourceRevisionFluent;
import io.fabric8.openshift.api.model.GitSourceRevisionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GitSourceRevisionBuilder
extends GitSourceRevisionFluentImpl<GitSourceRevisionBuilder>
implements VisitableBuilder<GitSourceRevision, GitSourceRevisionBuilder> {
    GitSourceRevisionFluent<?> fluent;
    Boolean validationEnabled;

    public GitSourceRevisionBuilder() {
        this(true);
    }

    public GitSourceRevisionBuilder(Boolean validationEnabled) {
        this(new GitSourceRevision(), validationEnabled);
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GitSourceRevision(), validationEnabled);
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent, GitSourceRevision instance) {
        this(fluent, instance, true);
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent, GitSourceRevision instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthor(instance.getAuthor());
        fluent.withCommit(instance.getCommit());
        fluent.withCommitter(instance.getCommitter());
        fluent.withMessage(instance.getMessage());
        this.validationEnabled = validationEnabled;
    }

    public GitSourceRevisionBuilder(GitSourceRevision instance) {
        this(instance, (Boolean)true);
    }

    public GitSourceRevisionBuilder(GitSourceRevision instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthor(instance.getAuthor());
        this.withCommit(instance.getCommit());
        this.withCommitter(instance.getCommitter());
        this.withMessage(instance.getMessage());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public GitSourceRevision build() {
        GitSourceRevision buildable = new GitSourceRevision(this.fluent.getAuthor(), this.fluent.getCommit(), this.fluent.getCommitter(), this.fluent.getMessage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitSourceRevisionBuilder that = (GitSourceRevisionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

