/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DockerImage;
import io.fabric8.openshift.api.model.DockerImageFluent;
import io.fabric8.openshift.api.model.DockerImageFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DockerImageBuilder
extends DockerImageFluentImpl<DockerImageBuilder>
implements VisitableBuilder<DockerImage, DockerImageBuilder> {
    DockerImageFluent<?> fluent;
    Boolean validationEnabled;

    public DockerImageBuilder() {
        this(true);
    }

    public DockerImageBuilder(Boolean validationEnabled) {
        this(new DockerImage(), validationEnabled);
    }

    public DockerImageBuilder(DockerImageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DockerImageBuilder(DockerImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DockerImage(), validationEnabled);
    }

    public DockerImageBuilder(DockerImageFluent<?> fluent, DockerImage instance) {
        this(fluent, instance, true);
    }

    public DockerImageBuilder(DockerImageFluent<?> fluent, DockerImage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArchitecture(instance.getArchitecture());
        fluent.withAuthor(instance.getAuthor());
        fluent.withComment(instance.getComment());
        fluent.withConfig(instance.getConfig());
        fluent.withContainer(instance.getContainer());
        fluent.withContainerConfig(instance.getContainerConfig());
        fluent.withCreated(instance.getCreated());
        fluent.withDockerVersion(instance.getDockerVersion());
        fluent.withId(instance.getId());
        fluent.withParent(instance.getParent());
        fluent.withSize(instance.getSize());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public DockerImageBuilder(DockerImage instance) {
        this(instance, (Boolean)true);
    }

    public DockerImageBuilder(DockerImage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withId(instance.getId());
        this.withParent(instance.getParent());
        this.withSize(instance.getSize());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DockerImage build() {
        DockerImage buildable = new DockerImage(this.fluent.getArchitecture(), this.fluent.getAuthor(), this.fluent.getComment(), this.fluent.getConfig(), this.fluent.getContainer(), this.fluent.getContainerConfig(), this.fluent.getCreated(), this.fluent.getDockerVersion(), this.fluent.getId(), this.fluent.getParent(), this.fluent.getSize(), this.fluent.getApiVersion(), this.fluent.getKind());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerImageBuilder that = (DockerImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

