/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class IdentityFluentImpl<A extends IdentityFluent<A>>
extends BaseFluent<A>
implements IdentityFluent<A> {
    private String apiVersion;
    private Map<String, String> extra = new LinkedHashMap<String, String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private String providerName;
    private String providerUserName;
    private VisitableBuilder<? extends ObjectReference, ?> user;

    public IdentityFluentImpl() {
    }

    public IdentityFluentImpl(Identity instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withExtra(instance.getExtra());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withProviderName(instance.getProviderName());
        this.withProviderUserName(instance.getProviderUserName());
        this.withUser(instance.getUser());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToExtra(String key, String value) {
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, String> map) {
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (key != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, String> extra) {
        this.extra.clear();
        if (extra != null) {
            this.extra.putAll(extra);
        }
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public IdentityFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public IdentityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public IdentityFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public A withProviderName(String providerName) {
        this.providerName = providerName;
        return (A)this;
    }

    @Override
    public String getProviderUserName() {
        return this.providerUserName;
    }

    @Override
    public A withProviderUserName(String providerUserName) {
        this.providerUserName = providerUserName;
        return (A)this;
    }

    @Override
    public ObjectReference getUser() {
        return this.user != null ? (ObjectReference)this.user.build() : null;
    }

    @Override
    public A withUser(ObjectReference user) {
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.add(this.user);
        }
        return (A)this;
    }

    @Override
    public IdentityFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public IdentityFluent.UserNested<A> withNewUserLike(ObjectReference item) {
        return new UserNestedImpl(item);
    }

    @Override
    public IdentityFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityFluentImpl that = (IdentityFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.providerName != null ? !this.providerName.equals(that.providerName) : that.providerName != null) {
            return false;
        }
        if (this.providerUserName != null ? !this.providerUserName.equals(that.providerUserName) : that.providerUserName != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class UserNestedImpl<N>
    extends ObjectReferenceFluentImpl<IdentityFluent.UserNested<N>>
    implements IdentityFluent.UserNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        UserNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        UserNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IdentityFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<IdentityFluent.MetadataNested<N>>
    implements IdentityFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)IdentityFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

