/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildTriggerPolicyBuilder
extends BuildTriggerPolicyFluentImpl<BuildTriggerPolicyBuilder>
implements VisitableBuilder<BuildTriggerPolicy, BuildTriggerPolicyBuilder> {
    BuildTriggerPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public BuildTriggerPolicyBuilder() {
        this(true);
    }

    public BuildTriggerPolicyBuilder(Boolean validationEnabled) {
        this(new BuildTriggerPolicy(), validationEnabled);
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildTriggerPolicy(), validationEnabled);
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent, BuildTriggerPolicy instance) {
        this(fluent, instance, true);
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent, BuildTriggerPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGeneric(instance.getGeneric());
        fluent.withGithub(instance.getGithub());
        fluent.withImageChange(instance.getImageChange());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance) {
        this(instance, (Boolean)true);
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGeneric(instance.getGeneric());
        this.withGithub(instance.getGithub());
        this.withImageChange(instance.getImageChange());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildTriggerPolicy build() {
        BuildTriggerPolicy buildable = new BuildTriggerPolicy(this.fluent.getGeneric(), this.fluent.getGithub(), this.fluent.getImageChange(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildTriggerPolicyBuilder that = (BuildTriggerPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

