/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ComponentCondition;
import io.fabric8.kubernetes.api.model.ComponentConditionBuilder;
import io.fabric8.kubernetes.api.model.ComponentConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ComponentStatusFluentImpl<A extends ComponentStatusFluent<A>>
extends BaseFluent<A>
implements ComponentStatusFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends ComponentCondition, ?>> conditions = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;

    public ComponentStatusFluentImpl() {
    }

    public ComponentStatusFluentImpl(ComponentStatus instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ComponentCondition> getConditions() {
        return ComponentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<ComponentCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(ComponentCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(ComponentCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public A addNewCondition(String error, String message, String status, String type) {
        return this.addToConditions(new ComponentCondition(error, message, status, type));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentStatusFluentImpl that = (ComponentStatusFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ComponentStatusFluent.MetadataNested<N>>
    implements ComponentStatusFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ComponentConditionFluentImpl<ComponentStatusFluent.ConditionsNested<N>>
    implements ComponentStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ComponentConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new ComponentConditionBuilder(this);
        }

        ConditionsNestedImpl(ComponentCondition item) {
            this.builder = new ComponentConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

