/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamespaceStatus;
import io.fabric8.kubernetes.api.model.NamespaceStatusFluent;
import io.fabric8.kubernetes.api.model.NamespaceStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamespaceStatusBuilder
extends NamespaceStatusFluentImpl<NamespaceStatusBuilder>
implements VisitableBuilder<NamespaceStatus, NamespaceStatusBuilder> {
    NamespaceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceStatusBuilder() {
        this(true);
    }

    public NamespaceStatusBuilder(Boolean validationEnabled) {
        this(new NamespaceStatus(), validationEnabled);
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamespaceStatus(), validationEnabled);
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent, NamespaceStatus instance) {
        this(fluent, instance, true);
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent, NamespaceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPhase(instance.getPhase());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceStatusBuilder(NamespaceStatus instance) {
        this(instance, (Boolean)true);
    }

    public NamespaceStatusBuilder(NamespaceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPhase(instance.getPhase());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NamespaceStatus build() {
        NamespaceStatus buildable = new NamespaceStatus(this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceStatusBuilder that = (NamespaceStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

