/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageSignatureFluent;
import io.fabric8.openshift.api.model.SignatureCondition;
import io.fabric8.openshift.api.model.SignatureConditionBuilder;
import io.fabric8.openshift.api.model.SignatureConditionFluentImpl;
import io.fabric8.openshift.api.model.SignatureIssuer;
import io.fabric8.openshift.api.model.SignatureIssuerBuilder;
import io.fabric8.openshift.api.model.SignatureIssuerFluentImpl;
import io.fabric8.openshift.api.model.SignatureSubject;
import io.fabric8.openshift.api.model.SignatureSubjectBuilder;
import io.fabric8.openshift.api.model.SignatureSubjectFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageSignatureFluentImpl<A extends ImageSignatureFluent<A>>
extends BaseFluent<A>
implements ImageSignatureFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends SignatureCondition, ?>> conditions = new ArrayList();
    private String content;
    private String created;
    private String imageIdentity;
    private VisitableBuilder<? extends SignatureIssuer, ?> issuedBy;
    private VisitableBuilder<? extends SignatureSubject, ?> issuedTo;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private Map<String, String> signedClaims = new LinkedHashMap<String, String>();
    private String type;

    public ImageSignatureFluentImpl() {
    }

    public ImageSignatureFluentImpl(ImageSignature instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withContent(instance.getContent());
        this.withCreated(instance.getCreated());
        this.withImageIdentity(instance.getImageIdentity());
        this.withIssuedBy(instance.getIssuedBy());
        this.withIssuedTo(instance.getIssuedTo());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignedClaims(instance.getSignedClaims());
        this.withType(instance.getType());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToConditions(SignatureCondition ... items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(SignatureCondition ... items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<SignatureCondition> getConditions() {
        return ImageSignatureFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<SignatureCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (SignatureCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(SignatureCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (SignatureCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public A withContent(String content) {
        this.content = content;
        return (A)this;
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    @Override
    public A withCreated(String created) {
        this.created = created;
        return (A)this;
    }

    @Override
    public String getImageIdentity() {
        return this.imageIdentity;
    }

    @Override
    public A withImageIdentity(String imageIdentity) {
        this.imageIdentity = imageIdentity;
        return (A)this;
    }

    @Override
    public SignatureIssuer getIssuedBy() {
        return this.issuedBy != null ? (SignatureIssuer)this.issuedBy.build() : null;
    }

    @Override
    public A withIssuedBy(SignatureIssuer issuedBy) {
        if (issuedBy != null) {
            this.issuedBy = new SignatureIssuerBuilder(issuedBy);
            this._visitables.add(this.issuedBy);
        }
        return (A)this;
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy() {
        return new IssuedByNestedImpl();
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item) {
        return new IssuedByNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> editIssuedBy() {
        return this.withNewIssuedByLike(this.getIssuedBy());
    }

    @Override
    public A withNewIssuedBy(String commonName, String organization) {
        return this.withIssuedBy(new SignatureIssuer(commonName, organization));
    }

    @Override
    public SignatureSubject getIssuedTo() {
        return this.issuedTo != null ? (SignatureSubject)this.issuedTo.build() : null;
    }

    @Override
    public A withIssuedTo(SignatureSubject issuedTo) {
        if (issuedTo != null) {
            this.issuedTo = new SignatureSubjectBuilder(issuedTo);
            this._visitables.add(this.issuedTo);
        }
        return (A)this;
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo() {
        return new IssuedToNestedImpl();
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item) {
        return new IssuedToNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> editIssuedTo() {
        return this.withNewIssuedToLike(this.getIssuedTo());
    }

    @Override
    public A withNewIssuedTo(String commonName, String organization, String publicKeyID) {
        return this.withIssuedTo(new SignatureSubject(commonName, organization, publicKeyID));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A addToSignedClaims(String key, String value) {
        if (key != null && value != null) {
            this.signedClaims.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSignedClaims(Map<String, String> map) {
        if (map != null) {
            this.signedClaims.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignedClaims(String key) {
        if (key != null) {
            this.signedClaims.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignedClaims(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.signedClaims.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSignedClaims() {
        return this.signedClaims;
    }

    @Override
    public A withSignedClaims(Map<String, String> signedClaims) {
        this.signedClaims.clear();
        if (signedClaims != null) {
            this.signedClaims.putAll(signedClaims);
        }
        return (A)this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSignatureFluentImpl that = (ImageSignatureFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.imageIdentity != null ? !this.imageIdentity.equals(that.imageIdentity) : that.imageIdentity != null) {
            return false;
        }
        if (this.issuedBy != null ? !this.issuedBy.equals(that.issuedBy) : that.issuedBy != null) {
            return false;
        }
        if (this.issuedTo != null ? !this.issuedTo.equals(that.issuedTo) : that.issuedTo != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.signedClaims != null ? !this.signedClaims.equals(that.signedClaims) : that.signedClaims != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageSignatureFluent.MetadataNested<N>>
    implements ImageSignatureFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class IssuedToNestedImpl<N>
    extends SignatureSubjectFluentImpl<ImageSignatureFluent.IssuedToNested<N>>
    implements ImageSignatureFluent.IssuedToNested<N>,
    Nested<N> {
        private final SignatureSubjectBuilder builder;

        IssuedToNestedImpl() {
            this.builder = new SignatureSubjectBuilder(this);
        }

        IssuedToNestedImpl(SignatureSubject item) {
            this.builder = new SignatureSubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withIssuedTo(this.builder.build());
        }

        @Override
        public N endIssuedTo() {
            return this.and();
        }
    }

    public class IssuedByNestedImpl<N>
    extends SignatureIssuerFluentImpl<ImageSignatureFluent.IssuedByNested<N>>
    implements ImageSignatureFluent.IssuedByNested<N>,
    Nested<N> {
        private final SignatureIssuerBuilder builder;

        IssuedByNestedImpl() {
            this.builder = new SignatureIssuerBuilder(this);
        }

        IssuedByNestedImpl(SignatureIssuer item) {
            this.builder = new SignatureIssuerBuilder(this, item);
        }

        @Override
        public N endIssuedBy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withIssuedBy(this.builder.build());
        }
    }

    public class ConditionsNestedImpl<N>
    extends SignatureConditionFluentImpl<ImageSignatureFluent.ConditionsNested<N>>
    implements ImageSignatureFluent.ConditionsNested<N>,
    Nested<N> {
        private final SignatureConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new SignatureConditionBuilder(this);
        }

        ConditionsNestedImpl(SignatureCondition item) {
            this.builder = new SignatureConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

