/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeploymentConfigSpecFluentImpl<A extends DeploymentConfigSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private Map<String, String> selector = new LinkedHashMap<String, String>();
    private VisitableBuilder<? extends DeploymentStrategy, ?> strategy;
    private VisitableBuilder<? extends PodTemplateSpec, ?> template;
    private Boolean test;
    private List<VisitableBuilder<? extends DeploymentTriggerPolicy, ?>> triggers = new ArrayList();

    public DeploymentConfigSpecFluentImpl() {
    }

    public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean isPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? (DeploymentStrategy)this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public Boolean isTest() {
        return this.test;
    }

    @Override
    public A withTest(Boolean test) {
        this.test = test;
        return (A)this;
    }

    @Override
    public A addToTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<DeploymentTriggerPolicy> getTriggers() {
        return DeploymentConfigSpecFluentImpl.build(this.triggers);
    }

    @Override
    public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggers(DeploymentTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.test != null ? !this.test.equals(that.test) : that.test != null) {
            return false;
        }
        return !(this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null);
    }

    public class TriggersNestedImpl<N>
    extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>>
    implements DeploymentConfigSpecFluent.TriggersNested<N>,
    Nested<N> {
        private final DeploymentTriggerPolicyBuilder builder;

        TriggersNestedImpl() {
            this.builder = new DeploymentTriggerPolicyBuilder(this);
        }

        TriggersNestedImpl(DeploymentTriggerPolicy item) {
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        @Override
        public N endTrigger() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.addToTriggers(this.builder.build());
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>>
    implements DeploymentConfigSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }

    public class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.StrategyNested<N>>
    implements DeploymentConfigSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }
}

