/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;

public class PodTemplateSpecFluentImpl<A extends PodTemplateSpecFluent<A>>
extends BaseFluent<A>
implements PodTemplateSpecFluent<A> {
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends PodSpec, ?> spec;

    public PodTemplateSpecFluentImpl() {
    }

    public PodTemplateSpecFluentImpl(PodTemplateSpec instance) {
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodTemplateSpecFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodSpec getSpec() {
        return this.spec != null ? (PodSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(PodSpec spec) {
        if (spec != null) {
            this.spec = new PodSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public PodTemplateSpecFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PodTemplateSpecFluent.SpecNested<A> withNewSpecLike(PodSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PodTemplateSpecFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodTemplateSpecFluentImpl that = (PodTemplateSpecFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.spec != null ? !this.spec.equals(that.spec) : that.spec != null);
    }

    public class SpecNestedImpl<N>
    extends PodSpecFluentImpl<PodTemplateSpecFluent.SpecNested<N>>
    implements PodTemplateSpecFluent.SpecNested<N>,
    Nested<N> {
        private final PodSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new PodSpecBuilder(this);
        }

        SpecNestedImpl(PodSpec item) {
            this.builder = new PodSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodTemplateSpecFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodTemplateSpecFluent.MetadataNested<N>>
    implements PodTemplateSpecFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodTemplateSpecFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

