/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonSetBuilder
extends DaemonSetFluentImpl<DaemonSetBuilder>
implements VisitableBuilder<DaemonSet, DaemonSetBuilder> {
    DaemonSetFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonSetBuilder() {
        this(true);
    }

    public DaemonSetBuilder(Boolean validationEnabled) {
        this(new DaemonSet(), validationEnabled);
    }

    public DaemonSetBuilder(DaemonSetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DaemonSetBuilder(DaemonSetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DaemonSet(), validationEnabled);
    }

    public DaemonSetBuilder(DaemonSetFluent<?> fluent, DaemonSet instance) {
        this(fluent, instance, true);
    }

    public DaemonSetBuilder(DaemonSetFluent<?> fluent, DaemonSet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public DaemonSetBuilder(DaemonSet instance) {
        this(instance, (Boolean)true);
    }

    public DaemonSetBuilder(DaemonSet instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DaemonSet build() {
        DaemonSet buildable = new DaemonSet(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetBuilder that = (DaemonSetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

