/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.PreconditionsBuilder;
import io.fabric8.kubernetes.api.model.PreconditionsFluentImpl;

public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements DeleteOptionsFluent<A> {
    private String apiVersion;
    private Long gracePeriodSeconds;
    private String kind;
    private VisitableBuilder<? extends Preconditions, ?> preconditions;

    public DeleteOptionsFluentImpl() {
    }

    public DeleteOptionsFluentImpl(DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withPreconditions(instance.getPreconditions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Preconditions getPreconditions() {
        return this.preconditions != null ? (Preconditions)this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(Preconditions preconditions) {
        if (preconditions != null) {
            this.preconditions = new PreconditionsBuilder(preconditions);
            this._visitables.add(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public A withNewPreconditions(String uid) {
        return this.withPreconditions(new Preconditions(uid));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null);
    }

    public class PreconditionsNestedImpl<N>
    extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>>
    implements DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        private final PreconditionsBuilder builder;

        PreconditionsNestedImpl() {
            this.builder = new PreconditionsBuilder(this);
        }

        PreconditionsNestedImpl(Preconditions item) {
            this.builder = new PreconditionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

