/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.api.model.WebHookTriggerFluent;
import io.fabric8.openshift.api.model.WebHookTriggerFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class WebHookTriggerBuilder
extends WebHookTriggerFluentImpl<WebHookTriggerBuilder>
implements VisitableBuilder<WebHookTrigger, WebHookTriggerBuilder> {
    WebHookTriggerFluent<?> fluent;
    Boolean validationEnabled;

    public WebHookTriggerBuilder() {
        this(true);
    }

    public WebHookTriggerBuilder(Boolean validationEnabled) {
        this(new WebHookTrigger(), validationEnabled);
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new WebHookTrigger(), validationEnabled);
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent, WebHookTrigger instance) {
        this(fluent, instance, true);
    }

    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent, WebHookTrigger instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowEnv(instance.getAllowEnv());
        fluent.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public WebHookTriggerBuilder(WebHookTrigger instance) {
        this(instance, (Boolean)true);
    }

    public WebHookTriggerBuilder(WebHookTrigger instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowEnv(instance.getAllowEnv());
        this.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public WebHookTrigger build() {
        WebHookTrigger buildable = new WebHookTrigger(this.fluent.isAllowEnv(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebHookTriggerBuilder that = (WebHookTriggerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

