/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicaSetStatusBuilder
extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder>
implements VisitableBuilder<ReplicaSetStatus, ReplicaSetStatusBuilder> {
    ReplicaSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicaSetStatusBuilder() {
        this(true);
    }

    public ReplicaSetStatusBuilder(Boolean validationEnabled) {
        this(new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, ReplicaSetStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, ReplicaSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicaSetStatus build() {
        ReplicaSetStatus buildable = new ReplicaSetStatus(this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

