/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentImpl;

public class ReplicationControllerFluentImpl<A extends ReplicationControllerFluent<A>>
extends BaseFluent<A>
implements ReplicationControllerFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ReplicationControllerSpec, ?> spec;
    private VisitableBuilder<? extends ReplicationControllerStatus, ?> status;

    public ReplicationControllerFluentImpl() {
    }

    public ReplicationControllerFluentImpl(ReplicationController instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ReplicationControllerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ReplicationControllerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ReplicationControllerFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ReplicationControllerSpec getSpec() {
        return this.spec != null ? (ReplicationControllerSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(ReplicationControllerSpec spec) {
        if (spec != null) {
            this.spec = new ReplicationControllerSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public ReplicationControllerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ReplicationControllerFluent.SpecNested<A> withNewSpecLike(ReplicationControllerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ReplicationControllerFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ReplicationControllerStatus getStatus() {
        return this.status != null ? (ReplicationControllerStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(ReplicationControllerStatus status) {
        if (status != null) {
            this.status = new ReplicationControllerStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public ReplicationControllerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ReplicationControllerFluent.StatusNested<A> withNewStatusLike(ReplicationControllerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ReplicationControllerFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer fullyLabeledReplicas, Long observedGeneration, Integer replicas) {
        return this.withStatus(new ReplicationControllerStatus(fullyLabeledReplicas, observedGeneration, replicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerFluentImpl that = (ReplicationControllerFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ReplicationControllerStatusFluentImpl<ReplicationControllerFluent.StatusNested<N>>
    implements ReplicationControllerFluent.StatusNested<N>,
    Nested<N> {
        private final ReplicationControllerStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new ReplicationControllerStatusBuilder(this);
        }

        StatusNestedImpl(ReplicationControllerStatus item) {
            this.builder = new ReplicationControllerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ReplicationControllerSpecFluentImpl<ReplicationControllerFluent.SpecNested<N>>
    implements ReplicationControllerFluent.SpecNested<N>,
    Nested<N> {
        private final ReplicationControllerSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new ReplicationControllerSpecBuilder(this);
        }

        SpecNestedImpl(ReplicationControllerSpec item) {
            this.builder = new ReplicationControllerSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicationControllerFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ReplicationControllerFluent.MetadataNested<N>>
    implements ReplicationControllerFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

