/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;

public class EndpointAddressFluentImpl<A extends EndpointAddressFluent<A>>
extends BaseFluent<A>
implements EndpointAddressFluent<A> {
    private String ip;
    private VisitableBuilder<? extends ObjectReference, ?> targetRef;

    public EndpointAddressFluentImpl() {
    }

    public EndpointAddressFluentImpl(EndpointAddress instance) {
        this.withIp(instance.getIp());
        this.withTargetRef(instance.getTargetRef());
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public ObjectReference getTargetRef() {
        return this.targetRef != null ? (ObjectReference)this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(ObjectReference targetRef) {
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressFluentImpl that = (EndpointAddressFluentImpl)o;
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        return !(this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null);
    }

    public class TargetRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<EndpointAddressFluent.TargetRefNested<N>>
    implements EndpointAddressFluent.TargetRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TargetRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        TargetRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EndpointAddressFluentImpl.this.withTargetRef(this.builder.build());
        }
    }
}

