/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesFluent;
import io.fabric8.kubernetes.api.model.CapabilitiesFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CapabilitiesBuilder
extends CapabilitiesFluentImpl<CapabilitiesBuilder>
implements VisitableBuilder<Capabilities, CapabilitiesBuilder> {
    CapabilitiesFluent<?> fluent;
    Boolean validationEnabled;

    public CapabilitiesBuilder() {
        this(true);
    }

    public CapabilitiesBuilder(Boolean validationEnabled) {
        this(new Capabilities(), validationEnabled);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Capabilities(), validationEnabled);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance) {
        this(fluent, instance, true);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdd(instance.getAdd());
        fluent.withDrop(instance.getDrop());
        this.validationEnabled = validationEnabled;
    }

    public CapabilitiesBuilder(Capabilities instance) {
        this(instance, (Boolean)true);
    }

    public CapabilitiesBuilder(Capabilities instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdd(instance.getAdd());
        this.withDrop(instance.getDrop());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Capabilities build() {
        Capabilities buildable = new Capabilities(this.fluent.getAdd(), this.fluent.getDrop());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapabilitiesBuilder that = (CapabilitiesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

