/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableRouteStatus;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RouteStatusBuilder
extends RouteStatusFluent<RouteStatusBuilder>
implements VisitableBuilder<RouteStatus, RouteStatusBuilder> {
    RouteStatusFluent<?> fluent;

    public RouteStatusBuilder() {
        this(new RouteStatus());
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
        this(fluent, new RouteStatus());
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance) {
        this.fluent = fluent;
    }

    public RouteStatusBuilder(RouteStatus instance) {
        this.fluent = this;
    }

    @Override
    public EditableRouteStatus build() {
        EditableRouteStatus buildable = new EditableRouteStatus();
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

