/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentImpl;
import io.fabric8.kubernetes.api.model.EditableContainerStateTerminated;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateTerminatedBuilder
extends ContainerStateTerminatedFluentImpl<ContainerStateTerminatedBuilder>
implements VisitableBuilder<ContainerStateTerminated, ContainerStateTerminatedBuilder> {
    ContainerStateTerminatedFluent<?> fluent;

    public ContainerStateTerminatedBuilder() {
        this(new ContainerStateTerminated());
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent) {
        this(fluent, new ContainerStateTerminated());
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent, ContainerStateTerminated instance) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withExitCode(instance.getExitCode());
        fluent.withFinishedAt(instance.getFinishedAt());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withSignal(instance.getSignal());
        fluent.withStartedAt(instance.getStartedAt());
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminated instance) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withSignal(instance.getSignal());
        this.withStartedAt(instance.getStartedAt());
    }

    @Override
    public EditableContainerStateTerminated build() {
        EditableContainerStateTerminated buildable = new EditableContainerStateTerminated(this.fluent.getContainerID(), this.fluent.getExitCode(), this.fluent.getFinishedAt(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getSignal(), this.fluent.getStartedAt());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateTerminatedBuilder that = (ContainerStateTerminatedBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

